<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Withdraw Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User</th>
                                        <th>Method</th>
                                        <th>Address</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    use App\Models\Deposit;use App\Models\Purchase;use App\Models\User;use App\Models\UserLedger;use App\Models\Withdrawal;
                                    ?>
                                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                        $user = $row->user;
                                        $myDeposit = Deposit::where('user_id', $row->user->id)->where('status', 'approved')->sum('amount');
                                        $myWithdraw = Withdrawal::where('user_id', $row->user->id)->where('status', 'approved')->sum('amount');
                                        ?>

                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <form action="<?php echo e(route('admin.search.submit')); ?>" method="get">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" id="ref_id" name="search" value="<?php echo e($row->user->ref_id ?? '--'); ?>">
                                                    <input type="submit" value="<?php echo e($row->user->ref_id ?? '--'); ?>" class="btn btn-success">
                                                </form>
                                                <br>
                                                My Deposit: <?php echo e(price($myDeposit)); ?> <br>
                                                My Withdraw: <?php echo e(price($myWithdraw)); ?>

                                            </td>
                                            <td>
                                                <?php echo e($row->method_name); ?>

                                            </td>
                                            <td>
                                                <?php echo e($row->number); ?>

                                            </td>
                                            <td>
                                                <?php echo e(price($row->final_amount)); ?>

                                            </td>
                                            <td>
                                                <span class="badge <?php if($row->status == 'pending'): ?> badge-warning <?php elseif($row->status == 'approved'): ?> badge-success  <?php elseif($row->status == 'rejected'): ?> badge-danger <?php endif; ?>" style="font-size: 8px"><?php echo e($row->status); ?></span>
                                            </td>
                                            <td>
                                                <?php if($row->status == 'pending'): ?>
                                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal<?php echo e($row->id); ?>" class="btn btn-success">Action</a>
                                                    <form action="<?php echo e(route('withdraw.status.change', $row->id)); ?>" method="POST"><?php echo csrf_field(); ?>
                                                        <div class="modal fade" id="myModal<?php echo e($row->id); ?>">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">

                                                                    <!-- Modal Header -->
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title">Action for withdraw</h4>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>

                                                                    <!-- Modal body -->
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <label for="status">Status <small class="text-info"> You can change withdraw status link approved, rejected, pending is default </small> </label>
                                                                            <select name="status" required id="status" class="form-control">
                                                                                <option value="approved" <?php if($row->status == 'approved'): ?> selected <?php endif; ?>>Approved</option>
                                                                                <option value="rejected" <?php if($row->status == 'rejected'): ?> selected <?php endif; ?>>Rejected</option>
                                                                                <option value="pending" <?php if($row->status == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Modal footer -->
                                                                    <div class="modal-footer">
                                                                        <input type="submit" value="Submit" class="btn btn-primary">
                                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                <?php else: ?>
                                                    <div class="text-info">Already push a action</div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kongjrnd/binirygift.site/resources/views/admin/pages/withdraw/list.blade.php ENDPATH**/ ?>